% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SweaveAscii.r
\name{Asciidoc}
\alias{Asciidoc}
\alias{T2t}
\alias{ReST}
\alias{Org}
\alias{Textile}
\alias{Pandoc}
\title{Sweave wrappers}
\usage{
Asciidoc(
  file,
  driver = RweaveAsciidoc,
  syntax = SweaveSyntaxNoweb,
  encoding = "",
  ...
)

T2t(file, driver = RweaveT2t, syntax = SweaveSyntaxNoweb, encoding = "", ...)

ReST(file, driver = RweaveReST, syntax = SweaveSyntaxNoweb, encoding = "", ...)

Org(file, driver = RweaveOrg, syntax = SweaveSyntaxNoweb, encoding = "", ...)

Textile(
  file,
  driver = RweaveTextile,
  syntax = SweaveSyntaxNoweb,
  encoding = "",
  ...
)

Pandoc(
  file,
  driver = RweavePandoc,
  syntax = SweaveSyntaxNoweb,
  encoding = "",
  ...
)
}
\arguments{
\item{file}{Name of Sweave source file.}

\item{driver}{Sweave driver}

\item{syntax}{Sweave syntax}

\item{encoding}{Encoding}

\item{...}{Further arguments passed to the driver's setup function.}
}
\description{
Sweave wrappers
}
\examples{
\dontrun{
testfile <- system.file("examples", "Org-test-1.nw", package = "ascii")

## enforce par(ask = FALSE)
options(device.ask.default = FALSE)

## create an org file - in the current working directory, getwd():
Org(testfile)
Org(testfile, driver=weaverOrg)

## This can be edited in and exported from Org Mode
}
}
\seealso{
\code{\link{Sweave}}
}
\author{
David Hajage \email{dhajage@gmail.com}
}
\keyword{IO}
\keyword{file}
