% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sampling2Dashape}
\alias{sampling2Dashape}
\title{Sampling 2D alpha shapes}
\usage{
sampling2Dashape(
  N,
  n.dependent = TRUE,
  nconnect = TRUE,
  nhomology = FALSE,
  n.noise = FALSE,
  afixed = FALSE,
  mu = 0.24,
  sigma = 0.05,
  delta = 0.05,
  n = 20,
  alpha = 0.24,
  lambda = 3,
  r = 1,
  rmin = 0.25,
  bound = "square"
)
}
\arguments{
\item{N}{number of alpha shapes to sample}

\item{n.dependent}{boolean, whether the number of points n are dependent on alpha}

\item{nconnect}{boolean, whether user wants shapes to have one connected component
with high probability}

\item{nhomology}{boolean, whether user wants shapes to preserve homology of
underlying manifold with high probability}

\item{n.noise}{boolean, whether to add noise variable to number of points n
for more variety in shapes}

\item{afixed}{boolean, whether alpha is fixed for all shapes sampled}

\item{mu}{mean value of truncated normal from which alpha is sampled}

\item{sigma}{standard deviation of truncated normal distribution from which
alpha is sampled}

\item{delta}{probability of getting disconnected shape or not preserving homology}

\item{n}{minimum number of points to be sampled for each alpha shape}

\item{alpha}{chosen fixed alpha; only used if afixed = TRUE}

\item{lambda}{parameter for adding noise to n; only used if n.noise=TRUE}

\item{r}{length of radius of circle, side length of square, or outer radius of annulus}

\item{rmin}{inner radius of annulus}

\item{bound}{compact manifold to be sampled from; either square, circle, or annulus}
}
\value{
list of alpha shapes of length N
}
\description{
This function takes parameter input from user and returns list of two dimensional
alpha shape objects from the ahull package.
}
