# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @description Fast inplace LDL decomposition of symmetric band matrix of length k.
#' @title LDL
#' @param D Rotated row-wised matrix of dimensions n*k, with first column corresponding to the diagonal, the second to the first super-diagonal and so on.
#' @return List with D as solution of our LDL decomposition.
#' @name LDL
#' @examples 
#' 
#' n=10;
#' D0=1:10;
#' D1=exp(-c(1:9));
#' D=cbind(D0,c(D1,0))
#' sol=LDL(D)
#' @export
NULL

LDL <- function(D) {
    .Call('_aspline_LDL', PACKAGE = 'aspline', D)
}

#' Create the penalty matrix
#'
#' @param w Vector of weights
#' @param diff Order of the differences to be applied to the parameters. Must be a strictly positive integer
#' @return Weighted penalty matrix \eqn{D^T diag(w) D} where
#'  \code{D <- diff(diag(length(w) + diff), differences = diff)}. Only the non-null superdiagonals of
#'  the weight matrix are returned, each column corresponding to a diagonal.
#' @export
band_weight <- function(w, diff) {
    .Call('_aspline_band_weight', PACKAGE = 'aspline', w, diff)
}

bandsolve_cpp <- function(D, B) {
    .Call('_aspline_bandsolve_cpp', PACKAGE = 'aspline', D, B)
}

#' Fast computation of weighted design matrix for generalized linear model
#'
#' @param w Vector of weights.
#' @param alpha Vector of indexes representing the start of blocks of the design matrix, as given by \link{block_design}.
#' @param B Design matrix in compressed block format, as given by \link{block_design}.
#' @return Weighted design matrix \eqn{X^T diag(w) X} where \code{X} is the design matrix and \code{W = diag(w)} is
#' a diagonal matrix of weights.
#' @export
weight_design_band <- function(w, alpha, B) {
    .Call('_aspline_weight_design_band', PACKAGE = 'aspline', w, alpha, B)
}

