% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_visualiser.R
\name{.parse_function}
\alias{.parse_function}
\title{Parse Function}
\usage{
.parse_function(x)
}
\arguments{
\item{x}{An R expression to be parsed.}
}
\value{
A character string or a list of parsed components, depending on the input expression.
}
\description{
This function parses an R expression, breaking it down into its components.
}
\details{
If the input expression \code{x} is not an atomic value, symbol, or an environment pointer,
the function breaks it up into a list of components. It also handles expressions of the
form \code{foo$bar} by splitting them up, keeping only the relevant parts for parsing.

If \code{x} is a list of expressions, the function recursively parses each expression until
they can no longer be listed, filtering out atomic values in the process.

If \code{x} is not listable (e.g. a function), it is deparsed into a character string.
}
