% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_compare.R
\name{assert_greater_than}
\alias{assert_greater_than}
\title{Assert input is greater than some minimum value}
\usage{
assert_greater_than(
  x,
  minimum,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check}

\item{minimum}{The minimum value to compare against (number)}

\item{msg}{A character string containing the error message to display if \code{x} is not greater than the specified minimum value (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is greater than the specified minimum value, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert a number is greater than a specified minimum value.
To check all numbers in a vector / matrix are above a minimum value, see \code{\link[=assert_all_greater_than]{assert_all_greater_than()}}
}
\examples{
try({
assert_greater_than(3, 2) # Passes
assert_greater_than(3, 2) # Passes
assert_greater_than(c(2,3,4), 1) # Throws error (Must be a number)
assert_greater_than('A', 1) # Throws error (Must be a number)
assert_greater_than(2, 3, msg = "custom error message") # Throws custom error
})

}
\concept{assert_comparison}
