% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_set.R
\name{assert_one_of}
\alias{assert_one_of}
\title{Check if a scalar value is one of the acceptable values}
\usage{
assert_one_of(x, y, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{A scalar value to check}

\item{y}{A vector of acceptable values that \code{x} can take}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
Returns invisible(TRUE) if \code{x} is a scalar and is one of the values in \code{y}, otherwise throws an error
}
\description{
Assert \code{x} is one of the values of \code{y}.
}
\examples{
assert_one_of(3, 1:5) # Passes because 3 is in 1:5
assert_one_of("A", c("A", "B", "C")) # Passes because "A" is in the vector

try({
  assert_one_of("D", c("A", "B", "C")) # Throws error because "D" is not in the vector
})
}
