% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_numerical.R
\name{assert_whole_number}
\alias{assert_whole_number}
\title{Assert that the input object is a whole number}
\usage{
assert_whole_number(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a whole number, otherwise aborts with the error message specified by \code{msg}
}
\description{
Check if \code{x} is a whole number (no decimal)
}
\examples{
try({
assert_whole_number(24) # Passes
assert_whole_number(2.5) # Throws error
})

}
\concept{assert_numerical}
