% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{model_evaluation}
\alias{model_evaluation}
\alias{modelEvaluation}
\title{Create model evaluation explanation}
\usage{
model_evaluation(object)

modelEvaluation(object)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\value{
An object of the class \code{auditor_model_evaluation}.
}
\description{
Creates explanation of classification model.

Returns, among others, true positive rate (tpr), false positive rate (fpr),
rate of positive prediction (rpp), and true positives (tp).

Created object of class \code{auditor_model_evaluation} can be used to plot
Receiver Operating Characteristic (ROC) curve (plot \code{\link{plot_roc}}) and LIFT curve (plot \code{\link{plot_lift}}).
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

glm_audit <- audit(model_glm,
                   data= titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
me <- model_evaluation(glm_audit)
me

plot(me)

}
