% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bagging.r
\name{bagging}
\alias{bagging}
\title{bagging method}
\usage{
bagging(form, data, ntrees, pruning, dselection, pruning_cp)
}
\arguments{
\item{form}{formula}

\item{data}{training data}

\item{ntrees}{ntrees}

\item{pruning}{model pruning method. A character vector. Currently, the
following methods are supported:
\describe{
   \item{mdsq}{Margin-distance minimisation}
   \item{bb}{boosting based pruning}
   \item{none}{no pruning}
}}

\item{dselection}{dynamic selection of the available models. Currently, the
following methods are supported:
\describe{
   \item{ola}{Overall Local Accuracy}
   \item{knora-e}{K-nearest-oracles-eliminate}
   \item{none}{no dynamic selection. Majority voting is used.}
}}

\item{pruning_cp}{The pruning cutpoint for the \code{pruning} method
picked.}
}
\description{
bagging method
}
\examples{
# splitting an example dataset into train/test:
train <- iris[1:(.7*nrow(iris)), ]
test <- iris[-c(1:(.7*nrow(iris))), ]
form <- Species ~.
# a user-defined bagging workflow
m <- bagging(form, iris, ntrees = 5, pruning = "bb", pruning_cp = .5, dselection = "ola")
preds <- predict(m, test)
# a standard bagging workflow with 5 trees (5 trees for examplification purposes):
m2 <- bagging(form, iris, ntrees = 5, pruning = "none", dselection = "none")
preds2 <- predict(m2, test)

}
\seealso{
\code{\link{baggedtrees}} for the implementation of the bagging model.
}
