% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapGO.R
\name{heatmapGO}
\alias{heatmapGO}
\title{HeatmapGO}
\usage{
heatmapGO(
  db,
  outfolder = "./results",
  log2FC_threshold = 0,
  padj_threshold = 0.05,
  min_term_per_row = 2,
  which_list = c("up_genes", "down_genes", "up_down_genes", "not_from_DE")
)
}
\arguments{
\item{db}{Database of choice to plot the heatmap. It has to be one for which the enrichment analysis has been performed.}

\item{outfolder}{The name to assign to the folder for output saving. (Default = "./results"). NOTE: please add "/" at the end.}

\item{log2FC_threshold}{Threshold value for log2(Fold Change) for considering genes as differentially expressed (Default = 0).}

\item{padj_threshold}{Threshold value for adjusted p-value significance (Defaults to 0.05).}

\item{min_term_per_row}{Minimum of comparisons or enriched lists on which a certain term must be significant (Defaults to 2).}

\item{which_list}{One of c("up_genes", "down_genes","up_down_genes", "not_from_DE"): select data to plot. Respectively, only up regulated genes (up_genes), only down regulated genes ("down_genes"), enrichment on both up and down regulated genes (up_down_genes) or select "not_from_DE" if the enrichment will be made on a list of genes that does not come from a differential expression analysis.}
}
\value{
No return value. Files will be produced as part of normal execution.
}
\description{
If the analysis has been performed on more conditions it is interest to have a look at the difference in the enrichment results between the groups. This can be performed by heatmapGO().

The function automatically reads all the enrichment results of the chosen database. A heatmap is produced for each database, all the terms are merged together and a filter is applied as follows: only terms with a significant pvalue (i.e. less than padj_threshold) in at least one comparison will be retained and plotted. These plots will be saved in the "Comparison_Heatmap" folder. In order to have readable plots, if many terms are enriched for a database several images will be created (indexed _1, _2, ...).
}
\examples{
\dontrun{
heatmapGO(
  db = "GO_Biological_Process_2021",
  outfolder = "./results",
  log2FC_threshold = 0,
  padj_threshold = 0.05,
  min_term_per_row = 3,
  which_list = "down_genes"
)
}
}
