% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_board.R
\name{plot_board}
\alias{plot_board}
\title{Data Painter Function
Draw K-S diagram, Lorenz diagram, lift diagram and  AUC diagram.}
\usage{
plot_board(label, pred)
}
\arguments{
\item{label}{A target variable.}

\item{pred}{A predictor variable.}
}
\value{
No return value, called for side effects
}
\description{
Data Painter Function
Draw K-S diagram, Lorenz diagram, lift diagram and  AUC diagram.
}
\examples{
accepts <- read.csv( system.file( "extdata", "accepts.csv" , package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
d = sort( sample( nrow( feature ), nrow( feature )*0.7))
train <- feature[d,]
test <- feature[-d,]
treebins_train <- bins_tree( df = train, key_var = "application_id", y_var="bad_ind",
max_depth=3, p=0.1)
woe_train <- rep_woe( df= train , key_var = "application_id", y_var = "bad_ind" ,
tool = treebins_train ,var_label = "variable",col_woe = 'woe', lower = 'lower' , upper = 'upper')
woe_test <- rep_woe(  df = test , key_var ="application_id", y_var= "bad_ind",
tool = treebins_train ,var_label= "variable",
    col_woe = 'woe', lower = 'lower' ,upper = 'upper'  )
lg<-stats::glm(bad_ind~.,family=stats::binomial(link='logit'),data= woe_train)
lg_both<-stats::step(lg,direction = "both")
logit<-stats::predict(lg_both,woe_test)
woe_test$lg_both_p<-exp(logit)/(1+exp(logit))
plot_board( label= woe_test$bad_ind, pred = woe_test$lg_both_p   )
}
