% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_doi_from_experiment_id.R
\name{get_doi_from_experiment_id}
\alias{get_doi_from_experiment_id}
\title{Get doi from experiment}
\usage{
get_doi_from_experiment_id(avida_experiment_id, triplestore)
}
\arguments{
\item{avida_experiment_id}{Integer or a list of integer values.}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "doi" "avida_experiment_id"
}
\description{
Get the DOI of the scientific publication that documents the
experiment carried out.
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single paper
get_doi_from_experiment_id(
  avida_experiment_id = 1,
  triplestore = avidaDB
)

# More than one experiment
get_doi_from_experiment_id(
  avida_experiment_id = c(1, 2, 4),
  triplestore = avidaDB
)

}
