% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_network_interfaces}
\alias{ec2_describe_network_interfaces}
\title{Describe Network Interfaces}
\usage{
ec2_describe_network_interfaces(
  Filter = NULL,
  DryRun = NULL,
  NetworkInterfaceId = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NetworkInterfaceId}{List.   One or more network interface IDs.  Default: Describes all your network interfaces.  [optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of items to return for this request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes one or more of your network
interfaces.
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{addresses.private-ip-address} - The private IPv4 addresses
associated with the network interface.
\item \code{addresses.primary} - Whether the private IPv4 address is the
primary IP address associated with the network interface.
\item \code{addresses.association.public-ip} - The association ID returned when
the network interface was associated with the Elastic IP address
(IPv4).
\item \code{addresses.association.owner-id} - The owner ID of the addresses
associated with the network interface.
\item \code{association.association-id} - The association ID returned when the
network interface was associated with an IPv4 address.
\item \code{association.allocation-id} - The allocation ID returned when you
allocated the Elastic IP address (IPv4) for your network interface.
\item \code{association.ip-owner-id} - The owner of the Elastic IP address
(IPv4) associated with the network interface.
\item \code{association.public-ip} - The address of the Elastic IP address
(IPv4) bound to the network interface.
\item \code{association.public-dns-name} - The public DNS name for the network
interface (IPv4).
\item \code{attachment.attachment-id} - The ID of the interface attachment.
\item \code{attachment.attach-time} - The time that the network interface was
attached to an instance.
\item \code{attachment.delete-on-termination} - Indicates whether the
attachment is deleted when an instance is terminated.
\item \code{attachment.device-index} - The device index to which the network
interface is attached.
\item \code{attachment.instance-id} - The ID of the instance to which the
network interface is attached.
\item \code{attachment.instance-owner-id} - The owner ID of the instance to
which the network interface is attached.
\item \code{attachment.status} - The status of the attachment (\code{attaching} \|
\code{attached} \| \code{detaching} \| \code{detached}).
\item \code{availability-zone} - The Availability Zone of the network
interface.
\item \code{description} - The description of the network interface.
\item \code{group-id} - The ID of a security group associated with the network
interface.
\item \code{group-name} - The name of a security group associated with the
network interface.
\item \code{ipv6-addresses.ipv6-address} - An IPv6 address associated with the
network interface.
\item \code{mac-address} - The MAC address of the network interface.
\item \code{network-interface-id} - The ID of the network interface.
\item \code{owner-id} - The AWS account ID of the network interface owner.
\item \code{private-ip-address} - The private IPv4 address or addresses of the
network interface.
\item \code{private-dns-name} - The private DNS name of the network interface
(IPv4).
\item \code{requester-id} - The alias or AWS account ID of the principal or
service that created the network interface.
\item \code{requester-managed} - Indicates whether the network interface is
being managed by an AWS service (for example, AWS Management
Console, Auto Scaling, and so on).
\item \code{source-dest-check} - Indicates whether the network interface
performs source/destination checking. A value of \code{true} means
checking is enabled, and \code{false} means checking is disabled. The
value must be \code{false} for the network interface to perform network
address translation (NAT) in your VPC.
\item \code{status} - The status of the network interface. If the network
interface is not attached to an instance, the status is \code{available};
if a network interface is attached to an instance the status is
\verb{in-use}.
\item \code{subnet-id} - The ID of the subnet for the network interface.
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC for the network interface.
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{NetworkInterfaceId}{


One or more network interface IDs.

Default: Describes all your network interfaces.
}

\section{MaxResults}{

The maximum number of items to return for
this request. The request returns a token that you can specify in a
subsequent call to get the next set of results. You cannot specify this
parameter and the network interface IDs parameter in the same
request.
}

