% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_reserved_instances_listings}
\alias{ec2_describe_reserved_instances_listings}
\title{Describe Reserved Instances Listings}
\usage{
ec2_describe_reserved_instances_listings(
  Filter = NULL,
  ReservedInstancesId = NULL,
  ReservedInstancesListingId = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{ReservedInstancesId}{Character. One or more Reserved Instance IDs.[optional]}

\item{ReservedInstancesListingId}{Character. One or more Reserved Instance listing IDs.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Reserved Instances Listings
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{reserved-instances-id} - The ID of the Reserved Instances.
\item \code{reserved-instances-listing-id} - The ID of the Reserved Instances
listing.
\item \code{status} - The status of the Reserved Instance listing (\code{pending} \|
\code{active} \| \code{cancelled} \| \code{closed}).
\item \code{status-message} - The reason for the status.
}
}

\section{ReservedInstancesId}{

One or more Reserved Instance
IDs.
}

\section{ReservedInstancesListingId}{

One or more Reserved Instance listing
IDs.
}

