% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_security_groups}
\alias{ec2_describe_security_groups}
\title{Describe Security Groups}
\usage{
ec2_describe_security_groups(
  Filter = NULL,
  GroupId = NULL,
  GroupName = NULL,
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{GroupId}{List.   The IDs of the security groups.[optional]}

\item{GroupName}{List.   [EC2-Classic and default VPC only] The names of the security groups.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Security Groups
}
\section{Filter}{


The filters. If using multiple filters for rules, the results include
security groups for which any combination of rules - not necessarily a
single rule - match all filters.
\itemize{
\item \code{description} - The description of the security group.
\item \code{egress.ip-permission.cidr} - An IPv4 CIDR block for an outbound
security group rule.
\item \code{egress.ip-permission.from-port} - For an outbound rule, the start
of port range for the TCP and UDP protocols, or an ICMP type number.
\item \code{egress.ip-permission.group-id} - The ID of a security group that
has been referenced in an outbound security group rule.
\item \code{egress.ip-permission.group-name} - The name of a security group
that is referenced in an outbound security group rule.
\item \code{egress.ip-permission.ipv6-cidr} - An IPv6 CIDR block for an
outbound security group rule.
\item \code{egress.ip-permission.prefix-list-id} - The ID of a prefix list to
which a security group rule allows outbound access.
\item \code{egress.ip-permission.protocol} - The IP protocol for an outbound
security group rule (\code{tcp} \| \code{udp} \| \code{icmp}, a protocol number, or
-1 for all protocols).
\item \code{egress.ip-permission.to-port} - For an outbound rule, the end of
port range for the TCP and UDP protocols, or an ICMP code.
\item \code{egress.ip-permission.user-id} - The ID of an AWS account that has
been referenced in an outbound security group rule.
\item \code{group-id} - The ID of the security group.
\item \code{group-name} - The name of the security group.
\item \code{ip-permission.cidr} - An IPv4 CIDR block for an inbound security
group rule.
\item \code{ip-permission.from-port} - For an inbound rule, the start of port
range for the TCP and UDP protocols, or an ICMP type number.
\item \code{ip-permission.group-id} - The ID of a security group that has been
referenced in an inbound security group rule.
\item \code{ip-permission.group-name} - The name of a security group that is
referenced in an inbound security group rule.
\item \code{ip-permission.ipv6-cidr} - An IPv6 CIDR block for an inbound
security group rule.
\item \code{ip-permission.prefix-list-id} - The ID of a prefix list from which
a security group rule allows inbound access.
\item \code{ip-permission.protocol} - The IP protocol for an inbound security
group rule (\code{tcp} \| \code{udp} \| \code{icmp}, a protocol number, or -1 for
all protocols).
\item \code{ip-permission.to-port} - For an inbound rule, the end of port range
for the TCP and UDP protocols, or an ICMP code.
\item \code{ip-permission.user-id} - The ID of an AWS account that has been
referenced in an inbound security group rule.
\item \code{owner-id} - The AWS account ID of the owner of the security group.
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC specified when the security group was
created.
}
}

\section{GroupId}{


The IDs of the security groups. Required for security groups in a
nondefault VPC.

Default: Describes all your security groups.
}

\section{GroupName}{


[EC2-Classic and default VPC only] The names of the security groups.
You can specify either the security group name or the security group ID.
For security groups in a nondefault VPC, use the \code{group-name} filter to
describe security groups by name.

Default: Describes all your security groups.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{MaxResults}{

The maximum number of results
to return in a single call. To retrieve the remaining results, make
another request with the returned \code{NextToken} value. This value can be
between 5 and 1000. If this parameter is not specified, then all results
are returned.
}

