% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_vpc_endpoints}
\alias{ec2_describe_vpc_endpoints}
\title{Describe Vpc Endpoints}
\usage{
ec2_describe_vpc_endpoints(
  DryRun = NULL,
  VpcEndpointId = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{VpcEndpointId}{List. One or more endpoint IDs.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer.   The maximum number of items to return for this request.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes one or more of your VPC
endpoints.
}
\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{VpcEndpointId}{

One or
more endpoint IDs.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{service-name} - The name of the service.
\item \code{vpc-id} - The ID of the VPC in which the endpoint resides.
\item \code{vpc-endpoint-id} - The ID of the endpoint.
\item \code{vpc-endpoint-state} - The state of the endpoint
(\code{pendingAcceptance} \| \code{pending} \| \code{available} \| \code{deleting} \|
\code{deleted} \| \code{rejected} \| \code{failed}).
\item \code{vpc-endpoint-type} - The type of VPC endpoint (\code{Interface} \|
\code{Gateway} \| \code{GatewayLoadBalancer}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}
}

\section{MaxResults}{


The maximum number of items to return for this request. The request
returns a token that you can specify in a subsequent call to get the
next set of results.

Constraint: If the value is greater than 1,000, we return only 1,000
items.
}

