% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_disassociate_enclave_certificate_iam_role}
\alias{ec2_disassociate_enclave_certificate_iam_role}
\title{Disassociate Enclave Certificate Iam Role}
\usage{
ec2_disassociate_enclave_certificate_iam_role(
  CertificateArn = NULL,
  RoleArn = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{CertificateArn}{Character. The ARN of the ACM certificate from which to disassociate the IAM role.[optional]}

\item{RoleArn}{Character. The ARN of the IAM role to disassociate.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Disassociates an IAM role from an AWS Certificate
Manager (ACM) certificate. Disassociating an IAM role from an ACM
certificate removes the Amazon S3 object that contains the certificate,
certificate chain, and encrypted private key from the Amazon S3 bucket.
It also revokes the IAM role\'s permission to use the AWS Key Management
Service (KMS) customer master key (CMK) used to encrypt the private key.
This effectively revokes the role\'s permission to use the certificate.
}
\section{CertificateArn}{

The ARN of the ACM
certificate from which to disassociate the IAM
role.
}

\section{RoleArn}{

The ARN of the IAM role to
disassociate.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

