% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_hosts}
\alias{ec2_modify_hosts}
\title{Modify Hosts}
\usage{
ec2_modify_hosts(
  HostId,
  AutoPlacement = NULL,
  HostRecovery = NULL,
  InstanceType = NULL,
  InstanceFamily = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{HostId}{List. The IDs of the Dedicated Hosts to modify.}

\item{AutoPlacement}{Character. Specify whether to enable or disable auto-placement.[optional]}

\item{HostRecovery}{Character. Indicates whether to enable or disable host recovery for the Dedicated Host.[optional]}

\item{InstanceType}{Character.   Specifies the instance type to be supported by the Dedicated Host.[optional]}

\item{InstanceFamily}{Character.   Specifies the instance family to be supported by the Dedicated Host.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify Hosts
}
\section{HostId}{

The IDs
of the Dedicated Hosts to modify.
}

\section{AutoPlacement}{

Specify whether to
enable or disable auto-placement.
}

\section{HostRecovery}{

Indicates whether
to enable or disable host recovery for the Dedicated Host. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html}{Host recovery}
in the \emph{Amazon EC2 User Guide}.
}

\section{InstanceType}{


Specifies the instance type to be supported by the Dedicated Host.
Specify this parameter to modify a Dedicated Host to support only a
specific instance type.

If you want to modify a Dedicated Host to support multiple instance
types in its current instance family, omit this parameter and specify
\strong{InstanceFamily} instead. You cannot specify \strong{InstanceType} and
\strong{InstanceFamily} in the same request.
}

\section{InstanceFamily}{


Specifies the instance family to be supported by the Dedicated Host.
Specify this parameter to modify a Dedicated Host to support multiple
instance types within its current instance family.

If you want to modify a Dedicated Host to support a specific instance
type only, omit this parameter and specify \strong{InstanceType} instead. You
cannot specify \strong{InstanceFamily} and \strong{InstanceType} in the same
request.
}

