% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_move_address_to_vpc}
\alias{ec2_move_address_to_vpc}
\title{Move Address To Vpc}
\usage{
ec2_move_address_to_vpc(
  PublicIp,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{PublicIp}{Character. The Elastic IP address.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Moves an Elastic IP address from the EC2-Classic
platform to the EC2-VPC platform. The Elastic IP address must be
allocated to your account for more than 24 hours, and it must not be
associated with an instance. After the Elastic IP address is moved, it
is no longer available for use in the EC2-Classic platform, unless you
move it back using the RestoreAddressToClassic request. You cannot move
an Elastic IP address that was originally allocated for use in the
EC2-VPC platform to the EC2-Classic platform.
}
\section{PublicIp}{

The Elastic IP
address.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

