% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_submit_attachment_state_changes}
\alias{ecs_submit_attachment_state_changes}
\title{Submit Attachment State Changes}
\usage{
ecs_submit_attachment_state_changes(
  cluster = NULL,
  attachments = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full ARN of the cluster that hosts the container instance the attachment belongs...}

\item{attachments}{List. Any attachments associated with the state change request.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Submit Attachment State Changes
}
\section{cluster}{

The short name or full ARN of the cluster
that hosts the container instance the attachment belongs
to.
}

\section{attachments}{

Any attachments associated with the state change
request.
}

