% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucketlist.R
\name{bucketlist}
\alias{bucketlist}
\alias{bucket_list_df}
\title{List Buckets}
\usage{
bucketlist(add_region = FALSE, ...)

bucket_list_df(add_region = FALSE, ...)
}
\arguments{
\item{add_region}{A logical (by default \code{FALSE}) indicating whether to add \dQuote{Region} column to the output data frame. This simply induces a loop over \code{\link{get_location}} for each bucket.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
A data frame of buckets. Can be empty (0 rows, 0 columns) if there are no buckets, otherwise contains typically at least columns \code{Bucket} and \code{CreationDate}.
}
\description{
List buckets as a data frame
}
\details{
\code{bucketlist} performs a GET operation on the base s3 endpoint and returns a list of all buckets owned by the authenticated sender of the request. If authentication is successful, this function provides a list of buckets available to the authenticated user. In this way, it can serve as a \dQuote{hello world!} function, to confirm that one's authentication credentials are working correctly.

\code{bucket_list_df} and \code{bucketlist} are identical.
}
\references{
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html}{API Documentation}
}
\seealso{
\code{\link{get_bucket}}, \code{\link{get_object}}
}
\keyword{service}
