% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/website.R
\name{delete_website}
\alias{delete_website}
\alias{put_website}
\alias{get_website}
\title{Bucket Website configuration}
\usage{
delete_website(bucket, ...)

put_website(bucket, request_body, ...)

get_website(bucket, ...)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}

\item{request_body}{A character string containing an XML request body, as defined in the specification in the \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html}{API Documentation}.}
}
\value{
For \code{put_website} and \code{get_website}, a list containing the website configuration, if one has been set.
For \code{delete_website}: \code{TRUE} if successful, \code{FALSE} otherwise.
An \code{aws_error} object may be returned if the request failed.
}
\description{
Get/Put/Delete the website configuration for a bucket.
}
\references{
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html}{API Documentation: PUT website}
 \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html}{API Documentation: GET website}
 \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html}{API Documentation: DELETE website}
}
