% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2.R
\name{signature_v2_auth}
\alias{signature_v2_auth}
\title{Signature Version 2}
\usage{
signature_v2_auth(
  datetime = format(Sys.time(), "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "UTC"),
  verb,
  service,
  path,
  query_args = list(),
  key = NULL,
  secret = NULL,
  region = NULL,
  force_credentials = FALSE,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{datetime}{A character string containing a date in the form of \dQuote{YYYY-MM-DDTH:M:S}. If missing, it is generated automatically using \code{\link[base]{Sys.time}}.}

\item{verb}{A character string specify an HTTP verb/method (e.g., \dQuote{GET}).}

\item{service}{A character string containing the full hostname of an AWS service (e.g., \dQuote{iam.amazonaws.com}, etc.)}

\item{path}{A character string specify the path to the API endpoint.}

\item{query_args}{A list containing named query arguments.}

\item{key}{An AWS Access Key ID. If \code{NULL}, it is retrieved using \code{\link{locate_credentials}}.}

\item{secret}{An AWS Secret Access Key. If \code{NULL}, it is retrieved using \code{\link{locate_credentials}}.}

\item{region}{A character string containing the AWS region for the request. If missing, \dQuote{us-east-1} is assumed.}

\item{force_credentials}{A logical indicating whether to force use of user-supplied credentials. If \code{FALSE} (the default), \code{\link{locate_credentials}} is used to find credentials. If \code{TRUE}, user-supplied values are used regardless of their validity.}

\item{verbose}{A logical indicating whether to be verbose.}
}
\value{
A list.
}
\description{
Generates AWS Signature Version 2
}
\details{
This function generates an AWS Signature Version 2 for authorizing API requests. The function returns both an updated set of query string parameters, containing the required signature-related entries, as well as a \code{Signature} field containing the Signature string itself. Version 2 is mostly deprecated and in most cases users should rely on \code{\link{signature_v4_auth}} for Version 4 signatures instead.
}
\examples{
\dontrun{
# examples from:
# http://docs.aws.amazon.com/general/latest/gr/signature-version-2.html

true_string <- paste0("GET\n",
"elasticmapreduce.amazonaws.com\n",
"/\n",
"AWSAccessKeyId=AKIAIOSFODNN7EXAMPLE",
"&Action=DescribeJobFlows",
"&SignatureMethod=HmacSHA256",
"&SignatureVersion=2",
"&Timestamp=2011-10-03T15\\%3A19\\%3A30",
"&Version=2009-03-31", collapse = "")
true_sig <- "i91nKc4PWAt0JJIdXwz9HxZCJDdiy6cf/Mj6vPxyYIs="

q1 <- 
list(Action = "DescribeJobFlows",
     Version = "2009-03-31",
     AWSAccessKeyId = "AKIAIOSFODNN7EXAMPLE",
     SignatureVersion = "2",
     SignatureMethod = "HmacSHA256",
     Timestamp = "2011-10-03T15:19:30")

sig1 <- 
signature_v2_auth(datetime = "2011-10-03T15:19:30",
                  service = "elasticmapreduce.amazonaws.com",
                  verb = "GET",
                  path = "/",
                  query_args = q1,
                  key = q1$AWSAccessKeyId,
                  secret = "wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY")
identical(true_string, sig1$CanonicalRequest)
identical(true_sig, sig1$Signature)

# leaving out some defaults
q2 <- 
list(Action = "DescribeJobFlows",
     Version = "2009-03-31",
     Timestamp = "2011-10-03T15:19:30")
sig2 <- 
signature_v2_auth(datetime = "2011-10-03T15:19:30",
                  service = "elasticmapreduce.amazonaws.com",
                  verb = "GET",
                  path = "/",
                  query_args = q2,
                  key = "AKIAIOSFODNN7EXAMPLE",
                  secret = "wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY")
identical(true_string, sig2$CanonicalRequest)
identical(true_sig, sig2$Signature)
}
}
\references{
\href{http://docs.aws.amazon.com/general/latest/gr/signature-version-2.html}{AWS General Reference: Signature Version 2 Signing Process}
}
\seealso{
\code{\link{signature_v4_auth}}, \code{\link{use_credentials}}
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
