% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{data_path}
\alias{data_path}
\title{Represents a path to data in a datastore.}
\usage{
data_path(datastore, path_on_datastore = NULL, name = NULL)
}
\arguments{
\item{datastore}{The Datastore to reference.}

\item{path_on_datastore}{The relative path in the backing storage for the data reference.}

\item{name}{An optional name for the DataPath.}
}
\value{
The \code{DataPath} object.
}
\description{
The path represented by DataPath object can point to a directory or a data artifact (blob, file).
}
\section{Examples}{
\preformatted{my_data <- register_azure_blob_container_datastore(
    workspace = ws,
    datastore_name = blob_datastore_name,
    container_name = ws_blob_datastore$container_name,
    account_name = ws_blob_datastore$account_name,
    account_key = ws_blob_datastore$account_key,
    create_if_not_exists = TRUE)

datapath <- data_path(my_data, <path_on_my_datastore>)
dataset <- create_file_dataset_from_files(datapath)
}
}

\seealso{
\code{\link{create_file_dataset_from_files}}
\code{\link{create_tabular_dataset_from_parquet_files}}
\code{\link{create_tabular_dataset_from_delimited_files}}
\code{\link{create_tabular_dataset_from_json_lines_files}}
\code{\link{create_tabular_dataset_from_sql_query}}
}
