% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace.R
\name{get_default_datastore}
\alias{get_default_datastore}
\title{Get the default datastore for a workspace}
\usage{
get_default_datastore(workspace)
}
\arguments{
\item{workspace}{The \code{Workspace} object.}
}
\value{
The default \code{Datastore} object.
}
\description{
Returns the default datastore associated with the workspace.

When you create a workspace, an Azure blob container and Azure file share
are registered to the workspace with the names \code{workspaceblobstore} and
\code{workspacefilestore}, respectively. They store the connection information
of the blob container and the file share that is provisioned in the storage
account attached to the workspace. The \code{workspaceblobstore} is set as the
default datastore, and remains the default datastore unless you set a new
datastore as the default with \code{set_default_datastore()}.
}
\section{Examples}{

Get the default datastore for the datastore:\preformatted{ws <- load_workspace_from_config()
ds <- get_default_datastore(ws)
}

If you have not changed the default datastore for the workspace, the
following code will return the same datastore object as the above
example:\preformatted{ws <- load_workspace_from_config()
ds <- get_datastore(ws, datastore_name = 'workspaceblobstore')
}
}

\seealso{
\code{\link[=set_default_datastore]{set_default_datastore()}}
}
