% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{log_residuals_to_run}
\alias{log_residuals_to_run}
\title{Log a residuals metric to a run}
\usage{
log_residuals_to_run(name, value, description = "", run = NULL)
}
\arguments{
\item{name}{A string of the name of the metric.}

\item{value}{A named list containing name, version, and data properties.}

\item{description}{(Optional) A string of the metric description.}

\item{run}{The \code{Run} object. If not specified, will default
to the current run from the service context.}
}
\value{
None
}
\description{
\code{log_residuals_to_run()} logs the data needed to display a histogram
of residuals for a regression task. The residuals are \code{predicted - actual}.

There should be one more edge than the number of counts.
}
\section{Examples}{
\preformatted{data <- list("bin_edges" = c(50, 100, 200, 300, 350),
             "bin_counts" = c(0.88, 20, 30, 50.99))
residuals <- list("schema_type" = "residuals",
                    "schema_version" = "v1",
                    "data" = data)
log_predictions_to_run("myresiduals", predictions)
}
}

