% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_rect.r
\name{round_rect}
\alias{round_rect}
\title{Plot a rectangle with rounded corners}
\usage{
round_rect(x1, y1, x2, y2, xr = 0.2, yr = 0.2, n = 10, ...)
}
\arguments{
\item{x1, y1}{x and y coordinates of the bottom left corner}

\item{x2, y2}{x and y coordinates of the top right corner}

\item{xr, yr}{the proportion of length of a side of the rectangle, from which the rounded corners
start. Values between 0 and 1 are permitted. See details.}

\item{n}{the number of points used to approximate the curvature of the rounded corner}

\item{...}{other parameters passed to [graphics::polygon()].}
}
\value{
No return value, called for side effects
}
\description{
Plot one or more rectangles with rounded corners.
}
\details{
The rounded corner is a part of a circle (one quarter) drawn between two points of neighbouring
sides of a rectangle. The relative position of these two points determine how rounded will the
final shape be. The position of these points is determined by the parameters `xr` and `yr`,
which determine the proportion of side x and y, from which the rounded corner is drawn.
Values between 0 and 1 are permitted, but given the symmetricity of a rectangle, values  larger
than 0.5 are reflected back (modulo 0.5). When both xr and yr are 0 or 1, normal rectangle
without rounded corners is drawn. When xr and yr are 0.5, ellipsis is drawn.
}
