% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_ma.R
\name{prepare_ma}
\alias{prepare_ma}
\title{Convert individual- to summary-level data in meta-analyses}
\usage{
prepare_ma(
  data,
  effect = c("mean", "logOR", "logRR", "RD"),
  rare_event_correction = 0.25,
  correction_type = c("single", "all"),
  log = FALSE,
  cfb = FALSE,
  summarise = TRUE,
  treatment = "treatment",
  baseline = NULL,
  group = "group",
  outcome = "outcome",
  pooling = FALSE
)
}
\arguments{
\item{data}{\strong{either} a data.frame of individual-level observations
with columns for outcome (numeric), treatment (values 0 and 1) and
group (numeric, character or factor); \strong{or}, a data frame with binary data
(must have columns \code{a}, \code{c}, \code{b}/\code{n1}, \code{d}/\code{n2}).}

\item{effect}{what effect to calculate? a \code{mean} (and SE) of outcome in groups or
(for binary data) \code{logOR} (odds ratio), \code{logRR} (risk ratio),
\code{RD} (risk difference);}

\item{rare_event_correction}{This correction is used when working with
binary data (effect \code{logOR} or \code{logRR})
The value of correction is added to all cells in
either some or all rows (groups), depending on \code{correction_type}.
Using corrections may bias results but is the only alternative to
avoid infinite values.}

\item{correction_type}{If \code{"single"} then rare event correction is only applied to the
particular rows that have 0 cells, if \code{"all"}, then to all studies}

\item{log}{logical; log-transform the outcome variable?}

\item{cfb}{logical; calculate change from baseline? If yes, the outcome
variable is taken as a difference between values in \code{outcome} and
\code{baseline} columns}

\item{summarise}{logical; \code{TRUE} by default, but you can disable it to obtain
converted (e.g. logged) data with columns renamed}

\item{treatment}{name of column with treatment variable; can be binary or
a factor (if using multiple treatment columns)}

\item{baseline}{name of column with baseline variable}

\item{group}{name of the column with grouping variable}

\item{outcome}{name of column with outcome variable}

\item{pooling}{Internal use only, please ignore}
}
\value{
\itemize{
\item If you \code{summarise}: a data.frame with columns for \code{group}, \code{tau} and \code{se.tau}
(for \code{effect = "mean"}, also baseline means; for \code{"logRR"} or \code{"logOR"} also
\code{a}, \code{b}, \code{c}, \code{d}, which correspond to typical contingency table notation, that is:
\code{a} = events in exposed; \code{b} = no events in exposed, \code{c} = events in unexposed,
\code{d} = no events in unexposed).
\item If you do not summarise data, individual level data will be returned, but
some columns may be renamed or transformed (see the arguments above).
}
}
\description{
Allows for one-way conversion from full to summary data
or for calculation of effects for binary data.
Usually used before calling \link{baggr}.
Input must be pre-formatted appropriately.
}
\details{
The conversions done by this function are not typically needed and may happen automatically
when \code{data} is given to \link{baggr}. However, this function can be used to explicitly
convert from full to reduced (summarised) data without analysing it in any model.
It can be useful for examining your data and generating summary tables.

If multiple operations are performed, they are taken in this order:
\enumerate{
\item conversion to log scale,
\item calculating change from baseline,
\item summarising data (using appropriate \code{effect})
}
}
\examples{

# Example of working with binary outcomes data
# Make up some individual-level data first:
df_rare <- data.frame(group = paste("Study", LETTERS[1:5]),
                      a = c(0, 2, 1, 3, 1), c = c(2, 2, 3, 3, 5),
                      n1i = c(120, 300, 110, 250, 95),
                      n2i = c(120, 300, 110, 250, 95))
df_rare_ind <- binary_to_individual(df_rare)
# Calculate ORs; default rare event correction will be applied
prepare_ma(df_rare_ind, effect = "logOR")
# Add 0.5 to all rows
prepare_ma(df_rare_ind, effect = "logOR",
           correction_type = "all",
           rare_event_correction = 0.5)
}
\seealso{
\link{convert_inputs} for how any type of data is (internally) converted into
a list of Stan inputs; vignette \code{baggr_binary} for more details about
rare event corrections
}
\author{
Witold Wiecek
}
