#'
#' Table of tropical cyclones that entered the Philippines from 2017 to 2020
#'
#' @format A data frame with 9 columns and 86 rows:
#'
#' | **Variable** | **Description** |
#' | :--- | :--- |
#' | *year* | Year |
#' | *category_code* | Tropical cyclone category code |
#' | *category_name* | Tropical cyclone category name |
#' | *name* | Name given to the tropical cyclone by Philippine authorities |
#' | *rsmc_name* | Name given to the tropical cyclone by RSMC |
#' | *start* | Date and time at which cyclone enters Philippine waters |
#' | *end* | Date and time at which cyclone leaves Philippine waters |
#' | *pressure* | Maximum central pressure in *hPa* |
#' | *speed* | Maximum sustained wind speed in *km/h* |
#'
#' @examples
#' bagyo
#'
#' @source Data are drawn from PAGASA's Annual Report on Philippine Tropical
#' Cyclones found at
#' https://www.pagasa.dost.gov.ph/tropical-cyclone/publications/annual-report
#'
"bagyo"
