% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episodes_raw.R
\docType{data}
\name{episodes_raw}
\alias{episodes_raw}
\title{Each episodes' challenges (raw)}
\format{
A data frame with 704 rows representing individual bakers per episode
and 6 variables:
\describe{
\item{series}{A factor denoting UK series (\code{1}-\code{10}).}
\item{episode}{A factor denoting episode number within a series.}
\item{baker}{A character string giving given or nickname.}
\item{signature}{A character string containing the bake for the signature
challenge for that baker/episode.}
\item{technical}{An integer denoting the rank on the technical challenge
for that baker/episode. A rank of \code{1} is winner of the technical
challenge.}
\item{showstopper}{A character string containing the bake for the
showstopper challenge for that baker/episode.}
}
}
\source{
See
\url{https://en.wikipedia.org/wiki/The_Great_British_Bake_Off#Format}
}
\usage{
episodes_raw
}
\description{
Details about the three challenges (signature, technical, and showstopper)
for each baker/episode across all 10 GBBO series.
}
\examples{
if (require('tibble')) {
  episodes_raw
 }
head(episodes_raw)
}
\keyword{datasets}
