% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop_s3.R
\name{\%eq\%.bandicoot_oop}
\alias{\%eq\%.bandicoot_oop}
\title{S3 method of performing the equals to operator of a
\code{bandicoot_oop} object}
\usage{
\method{\%eq\%}{bandicoot_oop}(x, y)
}
\arguments{
\item{x}{\code{bandicoot_oop} object.}

\item{y}{Object.}
}
\value{
A Boolean value.
}
\description{
This function performs the equals to operator using the \code{..eq..()} method.
If it is not applicable, error will be raised.
}
\examples{
AGE <- new_class(class_name = "AGE")
age <- AGE$instantiate
register_method(AGE, ..init.. = function(current) self$current = current)
register_method(AGE, ..eq.. = function(y) self$current == y$current)

patrick <- age(33)
james <- age(33)
patrick \%eq\% james

}
