% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_utils.R
\name{impose_floor}
\alias{impose_floor}
\title{Impose probability floor.}
\usage{
impose_floor(a, amin)
}
\arguments{
\item{a}{Numeric vector. Must not contain NA values.}

\item{amin}{Numeric. Minimum allowed value. Must be between 0 and 1.}
}
\value{
A numeric vector with the same length as \code{a}, with the floor imposed on its elements.
}
\description{
Imposes a floor on the given array a, ensuring that its elements are greater than or equal to amin.
}
\examples{
a <- c(0.25, 0.25, 0.25, 0.25)
imposed_a <- impose_floor(a = a, amin = 0.1)

}
