/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import OpenSourceExtensions.MersenneTwisterFast;
import bartMachine.bartMachine_b_hyperparams;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;

public class StatToolbox {
    private static final MersenneTwisterFast R = new MersenneTwisterFast();
    public static final double ILLEGAL_FLAG = -9.99999999E8;

    public static double sample_from_inv_gamma(double d, double d2) {
        return 1.0 / (d2 / 2.0) / bartMachine_b_hyperparams.samps_chi_sq_df_eq_nu_plus_n[(int)Math.floor(StatToolbox.rand() * (double)bartMachine_b_hyperparams.samps_chi_sq_df_eq_nu_plus_n_length)];
    }

    public static double sample_from_norm_dist(double d, double d2) {
        double d3 = bartMachine_b_hyperparams.samps_std_normal[(int)Math.floor(StatToolbox.rand() * (double)bartMachine_b_hyperparams.samps_std_normal_length)];
        return d + Math.sqrt(d2) * d3;
    }

    public static final double sample_average(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    public static final double sample_average(TDoubleArrayList tDoubleArrayList) {
        double d = 0.0;
        for (int i = 0; i < tDoubleArrayList.size(); ++i) {
            d += tDoubleArrayList.get(i);
        }
        return d / (double)tDoubleArrayList.size();
    }

    public static final double sample_average(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
        }
        return d / (double)nArray.length;
    }

    public static double sample_median(double[] dArray) {
        int n = dArray.length;
        Arrays.sort(dArray);
        if (n % 2 == 0) {
            double d = dArray[n / 2];
            double d2 = dArray[n / 2 - 1];
            return (d + d2) / 2.0;
        }
        return dArray[(n - 1) / 2];
    }

    public static final double sample_standard_deviation(int[] nArray) {
        double d = StatToolbox.sample_average(nArray);
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d2 += Math.pow((double)nArray[i] - d, 2.0);
        }
        return Math.sqrt(d2 / ((double)nArray.length - 1.0));
    }

    public static final double sample_standard_deviation(double[] dArray) {
        return Math.sqrt(StatToolbox.sample_variance(dArray));
    }

    public static final double sample_variance(double[] dArray) {
        return StatToolbox.sample_sum_sq_err(dArray) / ((double)dArray.length - 1.0);
    }

    public static final double sample_sum_sq_err(double[] dArray) {
        double d = StatToolbox.sample_average(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += Math.pow(dArray[i] - d, 2.0);
        }
        return d2;
    }

    public static double sample_minimum(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static double sample_maximum(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static double sample_minimum(double[] dArray) {
        double d = Double.MAX_VALUE;
        for (double d2 : dArray) {
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double sample_maximum(double[] dArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static int FindMaxIndex(int[] nArray) {
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
            n = i;
        }
        return n;
    }

    public static int multinomial_sample(TIntArrayList tIntArrayList, double[] dArray) {
        double d = StatToolbox.rand();
        double d2 = 0.0;
        int n = 0;
        if (d < dArray[0]) {
            return tIntArrayList.get(0);
        }
        while (!(d > (d2 += dArray[n])) || !(d < d2 + dArray[n + 1])) {
            ++n;
        }
        return tIntArrayList.get(n + 1);
    }

    public static void setSeed(long l) {
        R.setSeed(l);
    }

    public static double rand() {
        return R.nextDouble(false, false);
    }
}

