#' @title **Helper for determining whether a batted ball is a "barrel"**
#'
#' @description This function allows you to code a batted ball as a barrel as defined by the Statcast research team using data as provided by baseballsavant.mlb.com.
#' @param df A dataframe generated by baseballsavant.mlb.com that must include the following variables: `launch_angle` and `launch_speed`.
#' @return Returns a tibble with the additional column, `barrel`.
#' @export

code_barrel <- function(df) {
  df$barrel <- with(df, ifelse(launch_angle <= 50 & launch_speed >= 97 & launch_speed * 1.5 - 
                                 launch_angle >= 117 & launch_speed + launch_angle >= 123, 1, 0))
  return(df)
}
