% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Duplicates.R
\name{remove_duplicates}
\alias{remove_duplicates}
\title{Remove duplicate rows from data.frame}
\usage{
remove_duplicates(
  data,
  exclude_columns = NULL,
  ID_column = NULL,
  quiet = FALSE
)
}
\arguments{
\item{data}{data.frame to check}

\item{exclude_columns}{character vector, these columns are not considered in determining whether two rows are equal}

\item{ID_column}{character; column with identifiers to scan if possible duplicates remain}

\item{quiet}{logical: Should messages be printed?}
}
\value{
vector of row indices with non-unique data
}
\description{
Removes rows that are duplicates of another row in all columns except exclude_columns
}
\details{
Wraps unique()
}
\examples{
data <- data.frame(Study_ID = c("A", "B", "C"), ID = c(123, 456, 123), num_cars = c(10, 2, 10))
remove_duplicates(data, exclude_columns = "Study_ID")
remove_duplicates(data, exclude_columns = "Study_ID", ID_column = "ID")

}
\author{
J. Peter Marquardt
}
