% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monotonicity.R
\name{check_mon_between}
\alias{check_mon_between}
\alias{check_mon_between,OneStageBasket-method}
\title{Check Between-Trial Monotonicity}
\usage{
check_mon_between(design, ...)

\S4method{check_mon_between}{OneStageBasket}(
  design,
  n,
  lambda,
  weight_fun,
  weight_params = list(),
  details = TRUE,
  globalweight_fun = NULL,
  globalweight_params = list(),
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{details}{Whether the cases where the monotonicity condition is
violated should be returned, in case there are any.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}
}
\value{
If \code{details = FALSE} then only a logical value is returned.
If \code{details = TRUE} then if there are any cases where the
between-trial monotonicity condition is violated, a list of theses cases
and their results are returned.
}
\description{
Checks whether the between-trial monotonicity condition holds.
}
\details{
\code{check_mon_between} checks whether the between-trial
monotonicity condition holds. For a single-stage design with equal prior
distributions and equal sample sizes for each basket this condition states
that there are no cases where at least one null hypothesis is rejected when
when there is a case with an equal or higher number of responses in each
basket for which no null hypothesis is rejected.

If \code{prune = TRUE} then the baskets with an observed number of baskets
smaller than the pooled critical value are not borrowed from. The
pooled critical value is the smallest integer c for which all null
hypotheses can be rejected if the number of responses is exactly c for
all baskets.

The function is vectorized, such that vectors can be specified in
\code{weight_params} and \code{globalweight_params}.
}
\section{Methods (by class)}{
\itemize{
\item \code{check_mon_between(OneStageBasket)}: Between-trial monotonicity condition for a
single-stage design.

}}
\examples{
design <- setupOneStageBasket(k = 4, shape1 = 1, shape2 = 1, p0 = 0.2)

# Without vectorization, with details
check_mon_between(design = design, n = 24, lambda = 0.99,
  weight_fun = weights_fujikawa, weight_params = list(epsilon = 3,
    tau = 0), details = TRUE)

# Vectorized
\donttest{check_mon_between(design = design, n = 24, lambda = 0.99,
  weight_fun = weights_fujikawa,
  weight_params = list(epsilon = c(0.5, 1),  tau = c(0, 0.2, 0.3)),
  globalweight_fun = globalweights_fix,
  globalweight_params = list(w = c(0.5, 0.7)))}
}
\references{
Baumann, L., Krisam, J., & Kieser, M. (2022). Monotonicity conditions for
avoiding counterintuitive decisions in basket trials. Biometrical Journal,
64(5), 934-947.
}
