% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchmeans.R
\name{bm}
\alias{bm}
\title{Perform consistent batch means estimation on a vector of values from a Markov chain.}
\usage{
bm(x, size = "sqroot", warn = FALSE)
}
\arguments{
\item{x}{a vector of values from a Markov chain.}

\item{size}{the batch size. The default value is \dQuote{\code{sqroot}}, which uses the square root of the sample size. \dQuote{\code{cuberoot}} will cause the function to use the cube root of the sample size. A numeric value may be provided if neither \dQuote{\code{sqroot}} nor \dQuote{\code{cuberoot}} is satisfactory.}

\item{warn}{a logical value indicating whether the function should issue a warning if the sample size is too small (less than 1,000).}
}
\value{
\code{bm} returns a list with two elements:
        \item{est}{the mean of the vector.}
        \item{se}{the MCMC standard error based on the consistent batch means estimator.}
}
\description{
Perform consistent batch means estimation on a vector of values from a Markov chain.
}
\examples{

# Simulate a sample path of length 10,000 for an AR(1) chain with rho equal to 0.7.

X = numeric(10000)
X[1] = 1
for (i in 1:9999)
    X[i + 1] = 0.7 * X[i] + rnorm(1)

# Estimate the mean and MCSE.

bm(X)
}
\references{
Jones, G. L., Haran, M., Caffo, B. S. and Neath, R. (2006) Fixed-width output analysis for Markov chain Monte Carlo. \emph{Journal of the American Statistical Association}, \bold{101}, 1537--1547.

The following article is less technical and contains a direct comparison to the Gelman-Rubin diagnostic.

Flegal, J. M., Haran, M. and Jones, G. L. (2008) Markov chain Monte Carlo: Can we trust the third significant figure? \emph{Statistical Science}, \bold{23}, 250--260.
}
\seealso{
\code{\link{bmmat}}, which applies \code{bm} to each column of a matrix or data frame.
}

