#' Select root of the cubic based on the root of a nearest point
#'
#' @param parameters A vector of parameters (real numbers) that is generated by estimating the short, intermediate and auxiliary regressions.
#' @param mydelta The value of delta (real number). 
#' @param Rmax The value of Rmax (real number).
#' @param closest_bias The value of bias at the nearest point.
#'
#' @return Data frame
#' @export
#'
#' 
selectroot <- function(parameters, mydelta, Rmax, closest_bias){
  
  # Calculate roots and organize into dataframe
  roots <- as.data.frame(Re(mycubic(parameters, mydelta, Rmax))) %>%
    setNames("root") %>%
    # calculate magnitude of difference to closest root
    mutate(difference = abs(root-closest_bias))
  
  # Select root which is closest in absolute value to closest root and return
  output <- filter(roots,difference==min(roots$difference))$root
  return(output)
}
