% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{drosophila}
\alias{drosophila}
\title{Tissue type and transcription factor binding data during Drosophila mesoderm
development}
\format{
An object of class \code{"list"} containing tissue type and
transcription factor binding data. The first element in the list is a matrix
which contains the data in the original form. The second element in the list
is a matrix that contains the binary data. For this matrix any value greater
than zero to changed to a one. For both data sets the tissue type data
appears in the first six columns of the data matrix and the remaining 15
columns contain the transcription factor binding data.
}
\source{
\url{https://www.nature.com/articles/nature08531#Sec22}
}
\usage{
data(drosophila)
}
\description{
Zinzen et al. (2009) measured in vivo transcription factor binding for five
key transcription factors using ChIP-chip assays at two hour intervals during
drosophila mesoderm development. The five transcription factors are: Twist
(Twi), Tinman (Tin), Myocyte enhancing factor 2 (Mef2), Bagpipe (Bap), and
Biniou (Bin). Both Twi and Tin were assayed from 2-8 hours, Mef2 from 2-12
hours, Bap from 6-8 hours, and Bin from 6-12 hours. In addition, Zinzen et
al. identified six tissue types based on tissue specific expression: mesoderm
(Meso), somatic muscle (SM), visceral muscle (VM), cardiac muscle (CM),
mesoderm and somatic muscle (Meso&SM), and somatic and visceral muscle
(SM&VM). All data are binary and measured at 310 cis-regulatory modules.
}
\examples{
# Load the data.
data(drosophila)

# Display the first 5 rows and 8 columns of the continuous data matrix.
drosophila$continuous[1:5, 1:8]

# Display the first 5 rows and 8 columns of the discrete data matrix.
drosophila$discrete[1:5, 1:8]

}
\references{
Zinzen, R., Girardot, C., Gagneur, J. et al. Combinatorial
binding predicts spatio-temporal cis-regulatory activity. Nature 462, 65–70
(2009) doi:10.1038/nature08531
}
\keyword{datasets}
