% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcPotts.R
\name{gibbsNorm}
\alias{gibbsNorm}
\title{Fit a univariate normal (Gaussian) distribution to the observed data.}
\usage{
gibbsNorm(y, niter = 1000, priors = NULL)
}
\arguments{
\item{y}{A vector of observed pixel data.}

\item{niter}{The number of iterations of the algorithm to perform.}

\item{priors}{A list of priors for the parameters of the model.}
}
\value{
A list containing MCMC samples for the mean and standard deviation.
}
\description{
Fit a univariate normal (Gaussian) distribution to the observed data.
}
\examples{
y <- rnorm(100,mean=5,sd=2)
res.norm <- gibbsNorm(y, priors=list(mu=0, mu.sd=1e6, sigma=1e-3, sigma.nu=1e-3))
summary(res.norm$mu[501:1000])
summary(res.norm$sigma[501:1000])
}
