% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcplot.R
\name{pcplot}
\alias{pcplot}
\title{Principal component plot}
\usage{
pcplot(x, P0, G3D=FALSE,...)
}
\arguments{
\item{x}{an object of class \code{bmrm}, the output from the function \code{bmrm}}

\item{P0}{estimated value of P (in simulation it can be the true value of P)}

\item{G3D}{TRUE/FALSE, dynamic 3D plot (default=FALSE)}

\item{...}{arguments to be passed to methods}
}
\value{
plot
}
\description{
Draw principal component plots of data (Y) and
source profiles (rows) of the estimated source composition matrix P.hat
(and P0 if there is another source composition matrix P0 to compare, e.g.,
P0 could be the true P in simulation or P0 could be another estimate of P)
}
\examples{
\donttest{
data(Elpaso)
Y=Elpaso$Y ; muP=Elpaso$muP
q=nrow(muP)
out.Elpaso <- bmrm(Y,q,muP, nAdapt=1000,nBurnIn=5000,nIter=5000,nThin=1)
pcplot(out.Elpaso)
pcplot(out.Elpaso,G3D=TRUE)
}
}
