% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMF.R
\name{PMF.get_mean}
\alias{PMF.get_mean}
\title{Get the mean of the distribution from a PMF object}
\usage{
PMF.get_mean(pmf)
}
\arguments{
\item{pmf}{the PMF object.}
}
\value{
A numerical value for mean of the distribution.
}
\description{
Returns the mean from the PMF specified by \code{pmf}.
}
\examples{
library(bayesRecon)

# Let's build the pmf of a Binomial distribution with parameters n and p
n <- 10
p <- 0.6 
pmf_binomial <- apply(matrix(seq(0,10)),MARGIN=1,FUN=function(x) dbinom(x,size=n,prob=p))


# The true mean corresponds to n*p
true_mean <- n*p
mean_from_PMF <- PMF.get_mean(pmf=pmf_binomial)
cat("True mean:", true_mean, "\nMean from PMF:", mean_from_PMF)

}
\seealso{
\code{\link[=PMF.get_var]{PMF.get_var()}}, \code{\link[=PMF.get_quantile]{PMF.get_quantile()}}, \code{\link[=PMF.sample]{PMF.sample()}}, \code{\link[=PMF.summary]{PMF.summary()}}
}
