% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression_Functions.R
\name{dr_asympar}
\alias{dr_asympar}
\title{Binary glm object at several threshold values}
\usage{
dr_asympar(y, x, thresh, ...)
}
\arguments{
\item{y}{outcome variable}

\item{x}{matrix of covariates}

\item{thresh}{vector of threshold values on the support of outcome y}

\item{...}{additional arguments to pass to \code{lapl_aprx2}}
}
\value{
a list of glm objects corresponding to \code{thresh}
}
\description{
\code{dr_asympar} computes a normal approximation of the likelihood at a vector of threshold
values
}
\examples{
y = faithful$waiting
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
qtaus = quantile(y,c(0.05,0.25,0.5,0.75,0.95))
drabj<- dr_asympar(y=y,x=x,thresh = qtaus)
lapply(drabj,coef); lapply(drabj,vcov) 
# mean and covariance at respective threshold values

}
