% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{simcnfB}
\alias{simcnfB}
\title{Symmetric simultaneous bayesian confidence bands}
\usage{
simcnfB(DF, DFmat, alpha = 0.05, scale = FALSE)
}
\arguments{
\item{DF}{the target distribution/quantile function as a vector}

\item{DFmat}{the matrix of draws of the distribution, rows correspond to 
elements in \code{DF}}

\item{alpha}{level such that \code{1-alpha} is the desired probability of coverage}

\item{scale}{logical for scaling using the inter-quartile range}
}
\value{
cstar - a constant to add and subtract from DF to create 
 confidence bands if no scaling=FALSE else a vector of length DF.
}
\description{
\code{simcnfB} obtains symmetric bayesian distribution confidence bands
}
\examples{
set.seed(14); m=matrix(rbeta(500,1,4),nrow = 5) + 1:5
DF = apply(m,1,mean); plot(1:5,DF,type="l",ylim = c(0,max(m)), xlab = "Index")
symCB<- simcnfB(DF,DFmat = m)
lines(1:5,DF-symCB,lty=2); lines(1:5,DF+symCB,lty=2)

}
