% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{loo.varstan}
\alias{loo.varstan}
\alias{loo}
\title{Leave-one-out cross-validation}
\usage{
\method{loo}{varstan}(x, ...)
}
\arguments{
\item{x}{A \code{varstan} object}

\item{...}{additional values need in loo methods}
}
\value{
an object from the loo class with the results of the Pareto-Smooth
Importance Sampling, leave one out cross validation for model selection.
}
\description{
The \code{loo} method for \code{varstan} objects. Computes approximate
leave-one-out cross-validation using Pareto smoothed importance
sampling (PSIS-LOO CV).
}
\examples{
\donttest{
model = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
fit1 = varstan(model,iter = 500,chains = 1)

loo1 = loo(fit1)
loo1
}

}
\references{
Vehtari, A., Gelman, A., & Gabry J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. \emph{In Statistics
and Computing}, \code{doi:10.1007/s11222-016-9696-4}.

Gelman, A., Hwang, J., & Vehtari, A. (2014). Understanding predictive
information criteria for Bayesian models. \emph{Statistics and Computing}.
24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation
and widely applicable information criterion in singular learning theory.
\emph{The Journal of Machine Learning Research}. 11, 3571-3594.
}
\seealso{
The \pkg{loo} package \href{https://mc-stan.org/loo/articles/index.html}{vignettes}
for demonstrations. \code{psis()} for the underlying Pareto Smoothed Importance
Sampling (PSIS) procedure used in the LOO-CV approximation. \code{pareto-k-diagnostic}
for convenience functions for looking at diagnostics.\code{loo_compare()} for
model comparison.
}
