% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{mcmc_plot.varstan}
\alias{mcmc_plot.varstan}
\alias{mcmc_plot}
\title{MCMC Plots Implemented in \pkg{bayesplot}}
\usage{
\method{mcmc_plot}{varstan}(
  object,
  pars = NULL,
  combo = c("dens", "trace"),
  fixed = FALSE,
  exact_match = FALSE,
  ...
)

mcmc_plot(object, ...)
}
\arguments{
\item{object}{An \code{varstan} object.}

\item{pars}{Names of parameters to be plotted,
as given by a character vector or regular expressions.
By default, all parameters except for group-level and
smooth effects are plotted. May be ignored for some plots.}

\item{combo}{An array that contains the types of plot. By default
combo = c("dens","trace"). Supported types are (as names) \code{hist},
\code{dens}, \code{hist_by_chain}, \code{dens_overlay},
\code{violin}, \code{intervals}, \code{areas}, \code{acf},
\code{acf_bar},\code{trace}, \code{trace_highlight}, \code{scatter},
\code{rhat}, \code{rhat_hist}, \code{neff}, \code{neff_hist}
\code{nuts_acceptance}, \code{nuts_divergence},
\code{nuts_stepsize}, \code{nuts_treedepth}, and \code{nuts_energy}.
For an overview on the various plot types see
\code{\link[bayesplot:MCMC-overview]{MCMC-overview}}.}

\item{fixed}{Indicates whether parameter names
should be matched exactly (\code{TRUE}) or treated as
regular expressions (\code{FALSE}). Default is \code{FALSE}.}

\item{exact_match}{Deprecated alias of argument \code{fixed}.}

\item{...}{Additional arguments passed to the plotting functions.
See \code{\link[bayesplot:MCMC-overview]{MCMC-overview}} for
more details.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object
that can be further customized using the \pkg{ggplot2} package.
}
\description{
Convenient way to call MCMC plotting functions
implemented in the \pkg{bayesplot} package.
}
\examples{
\dontrun{
sf1 = stan_ssm(ipc,iter = 500,chains = 1)

# plot posterior intervals
mcmc_plot(sf1)

# only show population-level effects in the plots
mcmc_plot(sf1, pars = "level")
}

}
