% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life_compare.R
\name{life_compare}
\alias{life_compare}
\title{Compare life expectancies}
\usage{
life_compare(
  file_path,
  file = paste(file_path, "/mplotResults", sep = ""),
  state.include = 0,
  states,
  ref.var,
  ref.level,
  index.matrix,
  prop = TRUE,
  criterion = ">",
  state.names = NA
)
}
\arguments{
\item{file_path}{The file path for data reading. It can be inherited from \code{mlifetable_plot()}.}

\item{file}{The file path for outputs. Default is \code{paste(file_path,"/mplotResults",sep='')}.}

\item{state.include}{The status we aim to compare. It can be a number or a vector. Default is 0, which means we'll consider all states. It can be inherited from \code{mlifetable_plot()}.}

\item{states}{The total number of states in data. It can be inherited from \code{mlifetable_plot()}.}

\item{ref.var}{A vector containing all covariates used as comparison factors for each subgroup.}

\item{ref.level}{A vector that declares the reference value of each reference variable.}

\item{index.matrix}{A matrix that generated in \code{mlifeTable_plot()}. You don't need to specify it when using \code{mlifeTable_plot()}.}

\item{prop}{If TRUE, this function will output the comparision reulsts of life expectancy proportions in addition to orginal comparison results. Default is TRUE. It can be inherited from \code{mlifetable_plot()}.}

\item{criterion}{The criterion for comparison, which can be either ">" or "<". Default is ">".}

\item{state.names}{A vector used to specify names of each state except death. It can be inherited from \code{mlifetable_plot()}.}
}
\value{
A \code{.csv} file with comparison results.
}
\description{
A function for comparing the life expectancies of subgroups. This function will, by default, calculate the percentage of samples in your reference group with a higher (or lower) life expectancy (or proportion of total life expectancy) than other groups.
}
\examples{
\dontrun{

#By setting the parameter 'compare' in mlifeTable_plot() to TRUE. 
#We can directly employ this function.

mlifeTable_plot(X=lifedata[,-1],state.include = 3,
      groupby = c("male","black","hispanic"), 
      cred = 0.84, 
      states = 3,
      file_path = ".",
      compare = TRUE,
      ref.var = c("black","hispanic"),
      ref.level = c(0,0))

}
}
\seealso{
\code{\link{mlifeTable_plot}}
}
