% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.prediction}
\alias{plot.prediction}
\title{Plot a \code{prediction} object.}
\usage{
\method{plot}{prediction}(...)
}
\arguments{
\item{...}{Arguments passed on to \code{predictplot}.}
}
\description{
Plot a \code{prediction} object.
}
\examples{
data(bassriver)

# Using the "pooled annual" calibration model:
sst <- predict_seatemp(bassriver$d18o, d18osw=0.0, 
                       prior_mean=30.0, prior_std=20.0)

predictplot(x=bassriver$depth, y=sst, ylim=c(20, 40), 
            ylab="SST (°C)", xlab="Depth (m)")

}
\seealso{
\code{\link{predictplot}}
}
