% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knnImputation.R
\name{rho_knn}
\alias{rho_knn}
\title{K nearest-neighbor (KNN) regression}
\usage{
rho_knn(
  x_mat,
  dise_vec,
  veri_stat,
  k,
  type = c("eucli", "manha", "canber", "lagran", "mahala"),
  trace = FALSE
)
}
\arguments{
\item{x_mat}{a numeric design matrix.}

\item{dise_vec}{a n * 3  binary matrix with three columns, corresponding to the three classes of the disease status. In row i, 1 in column j indicates that the i-th subject belongs to class j, with j = 1, 2, 3. A row of \code{NA} values indicates a non-verified subject.}

\item{veri_stat}{a binary vector containing the verification status (1 verified, 0 not verified).}

\item{k}{an integer value/vector, which indicates the number of nearest neighbors. It should be less than the number of the verification subjects.}

\item{type}{a distance measure.}

\item{trace}{switch for tracing estimation process. Default \code{FALSE}.}
}
\value{
\code{rho_knn} returns a list containing the following components:
 \item{values}{estimates of the probabilities.}
 \item{X}{a design model matrix.}
 \item{K}{the number of nearest neighbors.}
 \item{type}{the chosen distance.}
}
\description{
\code{rho_knn} uses the KNN approach to estimate the probabilities of the disease status in case of three categories.
}
\details{
\code{type} should be selected as one of \code{"eucli"}, \code{"manha"}, \code{"canber"}, \code{"lagran"}, \code{"mahala"} corresponding to Euclidean, Manhattan, Canberra, Lagrange and Mahalanobis distance. In practice, the selection of a suitable distance is typically dictated by features of the data and possible subjective evaluations. For example, if the covariates are heterogeneous with respect to their variances (which is particularly true when the variables are measured on heterogeneous scales), the choice of the Mahalanobis distance may be a good choice.

For the number of nearest neighbors, a small value of \code{k}, within the range 1-3, may be a good choice. In general, the choice of \code{k} may depend on the dimension of the feature space, and propose to use cross--validation to find \code{k} in case of high--dimensional covariate. See \code{\link{cv_knn}}.
}
\examples{
data(EOC)
x_mat <- cbind(EOC$CA125, EOC$CA153, EOC$Age)
dise_na <- pre_data(EOC$D, EOC$CA125)
dise_vec_na <- dise_na$dise_vec

## Euclidean distance, k = 1
out_ecul_1nn <- rho_knn(x_mat, dise_vec_na, EOC$V, k = 1, type = "eucli")

## Manhattan distance, k = 1
out_manh_1nn <- rho_knn(x_mat, dise_vec_na, EOC$V, k = 1, type = "manha")

## Canberra distance, k = 3
out_canb_1nn <- rho_knn(x_mat, dise_vec_na, EOC$V, k = 3, type = "canber")

## Lagrange distance, k = 3
out_lagr_1nn <- rho_knn(x_mat, dise_vec_na, EOC$V, k = 3, type = "lagran")

## Mahalanobis distance, k = c(1,3)
out_maha_13nn <- rho_knn(x_mat, dise_vec_na, EOC$V, k = c(1, 3),
                         type = "mahala")

}
\references{
To Duc, K., Chiogna, M. and Adimari, G. (2020)
Nonparametric estimation of ROC surfaces in presence of verification bias.
\emph{REVSTAT-Statistical Journal}. \bold{18}, 5, 697–720.
}
