% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Request.R
\docType{class}
\name{Request}
\alias{Request}
\title{Request Class}
\format{
An [`R6::R6Class`] generator for `Request` objects.
}
\description{
A `Request` object represents an incoming HTTP request. It stores query
string, parameters, body, headers, method, and protocol information.
By convention, the request object is named `req` (with the corresponding
response named `res`).
}
\seealso{
[Response]
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{parameters}}{Named list of route parameters.}

\item{\code{headers}}{Named list of request headers.}

\item{\code{path}}{The request path.}

\item{\code{method}}{HTTP method (e.g., `"GET"`, `"POST"`).}

\item{\code{raw}}{The raw request object as received.}

\item{\code{type}}{Content type (e.g., `"text/html"`, `"application/json"`).}

\item{\code{body}}{Raw request body as a single string.}

\item{\code{protocol}}{Protocol string (`"http"` or `"websocket"`).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Request-attach}{\code{Request$attach()}}
\item \href{#method-Request-getHeader}{\code{Request$getHeader()}}
\item \href{#method-Request-setHeader}{\code{Request$setHeader()}}
\item \href{#method-Request-addParameters}{\code{Request$addParameters()}}
\item \href{#method-Request-new}{\code{Request$new()}}
\item \href{#method-Request-clone}{\code{Request$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-attach"></a>}}
\if{latex}{\out{\hypertarget{method-Request-attach}{}}}
\subsection{Method \code{attach()}}{
Attach a parameter key-value to `parameters`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$attach(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Parameter name.}

\item{\code{value}}{Parameter value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getHeader"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getHeader}{}}}
\subsection{Method \code{getHeader()}}{
Get the value of a request header.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getHeader(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Header name (case-insensitive).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-setHeader"></a>}}
\if{latex}{\out{\hypertarget{method-Request-setHeader}{}}}
\subsection{Method \code{setHeader()}}{
Set or overwrite a request header.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$setHeader(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Header name.}

\item{\code{value}}{Header value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-addParameters"></a>}}
\if{latex}{\out{\hypertarget{method-Request-addParameters}{}}}
\subsection{Method \code{addParameters()}}{
Merge a named list of parameters into `parameters`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$addParameters(named_list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{named_list}}{Named list of key-value pairs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-new"></a>}}
\if{latex}{\out{\hypertarget{method-Request-new}{}}}
\subsection{Method \code{new()}}{
Parse fields from the raw request and populate the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$new(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{Raw request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Request-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
